#ifndef __MT_TURR_VIEWER_H__
#define __MT_TURR_VIEWER_H__

#include "MTViewer.h"
#include "MTInfoWindow.h"

struct MTTURRParsedEntry
{
	std::string	name;
	UInt32		data[14];
};

class MTTURRViewer : public MTInfoWindow, public MTViewer
{
	public:
		void	ParseData(UInt8 * buf, UInt32 bufSize);
	
	private:
		static MTInfoWindowDataTemplate	kTURRTemplate;
		
		UInt32		id, version;
		std::string	name;
		UInt32		unknown1;
		UInt16		unknown2;
		UInt16		unknown3;
		UInt32		m3gmID1;
		UInt32		unknown4;
		UInt32		unknown5;
		UInt32		m3gmID2;
		UInt32		unknown6;
		UInt32		m3gmID3;
		UInt32		unknown7;
		UInt32		data1[6];
		std::vector <MTTURRParsedEntry>	entries;
		UInt16		data2[104];
		std::string	defaultState;
		UInt32		unknown8;
};

#endif /* __MT_TURR_VIEWER_H__ */